/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.api.JadeIds;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.network.ClientPayloadContext;
import snownee.jade.util.JsonConfig;

public record ServerPingPacket(String serverConfig, List<class_2248> shearableBlocks, List<class_2960> blockProviderIds, List<class_2960> entityProviderIds) implements class_8710
{
    public static final class_8710.class_9154<ServerPingPacket> TYPE = new class_8710.class_9154(JadeIds.PACKET_SERVER_PING);
    public static final class_9139<class_9129, ServerPingPacket> CODEC = class_9139.method_56905((class_9139)class_9135.field_48554, ServerPingPacket::serverConfig, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41254).method_56433(class_9135.method_56363()), ServerPingPacket::shearableBlocks, (class_9139)class_9135.method_56363().apply(class_2960.field_48267), ServerPingPacket::blockProviderIds, (class_9139)class_9135.method_56363().apply(class_2960.field_48267), ServerPingPacket::entityProviderIds, ServerPingPacket::new);

    public static void handle(ServerPingPacket message, ClientPayloadContext context) {
        JsonObject json;
        String s = message.serverConfig;
        try {
            json = s.isEmpty() ? null : (JsonObject)JsonConfig.GSON.fromJson(s, JsonObject.class);
        }
        catch (Throwable e) {
            Jade.LOGGER.error("Received malformed config from the server: {}", (Object)s);
            return;
        }
        context.execute(() -> {
            ObjectDataCenter.serverConnected = true;
            PluginConfig.INSTANCE.reload();
            if (json != null && !json.keySet().isEmpty()) {
                PluginConfig.INSTANCE.applyServerConfigs(json);
            }
            HarvestToolProvider.INSTANCE.setShearableBlocks(message.shearableBlocks);
            WailaCommonRegistration.instance().blockDataProviders.remapIds(message.blockProviderIds);
            WailaCommonRegistration.instance().entityDataProviders.remapIds(message.entityProviderIds);
            Jade.LOGGER.info("Received config from the server: {}", (Object)message.serverConfig);
        });
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

